<?php
/* --------------------------------------------------------------
 ConfigurationLabel.php 2019-10-18
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2019 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Models\Read;

/**
 * Class ConfigurationLabel
 * @package Gambio\Core\Configuration\Models
 */
class ConfigurationGroupItemLabel
{
    public const TITLE       = 'title';
    public const DESCRIPTION = 'description';
    
    /**
     * @var string
     */
    private $title;
    
    /**
     * @var string
     */
    private $description;
    
    
    /**
     * ConfigurationLabel constructor.
     *
     * @param string $title
     * @param string $description
     */
    private function __construct(string $title, string $description)
    {
        $this->title       = $title;
        $this->description = $description;
    }
    
    
    /**
     * Factory method for ConfigurationLabel.
     *
     * @param string $title
     * @param string $description
     *
     * @return ConfigurationGroupItemLabel
     */
    public static function create(string $title, string $description): self
    {
        return new static($title, $description);
    }
    
    
    /**
     * Array serialization.
     *
     * @return array
     */
    public function toArray(): array
    {
        return [
            self::TITLE       => $this->title,
            self::DESCRIPTION => $this->description,
        ];
    }
}